package jgame.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;

public class UriUtil {
	static Pattern ABSPATHPAT = Pattern.compile("^(?:[^/]+:|/).*");
	
	public static String getAbsoluteResourcePath( String path, Class relativeTo ) {
		if( ABSPATHPAT.matcher(path).find() ) {
			// Path is already URI (xxx:...) or absolute path (/...); 
			// do not change
			return path;
		} else {
			// path does not start with "/": prepend package name
			// with "." in package replaced by fileseparator
			// this doesn't work as getPackage may return null for applets
			// String pkgname = getClass().getPackage().getName();
			String pkgname = relativeTo.getName();
			String pkgname_path="";
			Vector tokens = StringUtil.tokenizeString(pkgname,'.');
			//StringTokenizer toker = new StringTokenizer(pkgname,".");
			for (Enumeration e=tokens.elements();e.hasMoreElements();) {
				String tok = (String)e.nextElement();
				if (e.hasMoreElements()) {
					pkgname_path += tok + "/";
				}
			}
			return "/" + pkgname_path + path;
		}
	}
	
	/**
	 * If given URI looks like an absolute URI,
	 * create a java.net.URL object from it.  Otherwise
	 * uses getResource to find a URL for the named resource.
	 */
	public static URL parseResourceUrl( String uri ) {
		if( uri.matches("[^:/]+:.*") ) {
			try {
				return new URL(uri);
			} catch (MalformedURLException e) {
				throw new RuntimeException(e);
			}
		} else {
			return UriUtil.class.getResource(uri);
		}
	}
}
