package jgame.impl;

import jgame.JGObject;

public final class YDepthComparator extends DepthComparator {
	final float yFactor;
	final float depthFactor;
	final EngineLogic el;
	public YDepthComparator( EngineLogic el ) {
		this( 1.0f, 1.0f, el );
	}
	public YDepthComparator( float depthFactor, float yFactor, EngineLogic el ) {
		this.yFactor = yFactor;
		this.depthFactor = depthFactor;
		this.el = el;
	}
	protected final float getDepth( JGObject o ) {
		return (float)(o.depth * depthFactor + el.moduloYPos(o.y) * yFactor);
	}
}