package togos.game2;

import java.util.Set;

import jgame.JGObject;
import jgame.JGPoint;
import jgame.JGRectangle;
import jgame.platform.JGEngine;
import togos.game2.data.ConstantDDD;
import togos.game2.data.MapFunction;
import togos.game2.data.WeakRefCache;
import togos.game2.function.FunctionOO;
import togos.game2.jgame.JGameTG2Engine;
import togos.game2.world.accessor.BasicWorldAccessor;
import togos.game2.world.behavior.Behavable;
import togos.game2.world.behavior.Behavior;
import togos.game2.world.constants.CollisionFlags;
import togos.game2.world.definitions.Section;
import togos.game2.world.definitions.impl.BasicBoundingBox;
import togos.game2.world.definitions.impl.BasicPlane;
import togos.game2.world.definitions.impl.BasicRegularImageSheet;
import togos.game2.world.definitions.impl.BasicSprite;
import togos.game2.worldgen.NoiseSectionGenerator;
import togos.game2.worldgen.OverlaySectionGenerator;
import togos.game2.worldgen.Vegetator;
import togos.game2.worldgen.WorldTileAccessor;
import togos.game2.worldgen.noise.D5_2Perlin;
import togos.game2.worldgen.noise.MultiMultiplyNoise;

public class TestGame extends JGEngine
{
	JGameTG2Engine e2;

	////
	
	public static class Butterflyish implements Behavior {
		Behavable target;
		public Butterflyish( Behavable target ) {
			this.target = target;
		}
		
		protected double timeSinceLastFlap = 10;
		protected boolean flapFrame = false;
		public void doStuff(double interval) {
			boolean flap = true;
			timeSinceLastFlap += interval;
			if( timeSinceLastFlap > 0.15 ) {
				if( target.getZ() < 1.0 ) {
					flap = true;
				} else if( target.getZ() > 3.0 ) {
					flap = false; 
				} else {
					flap = Math.random() < 0.1;
				}
			} else {
				flap = false;
			}
			if( flapFrame && timeSinceLastFlap > 0.07 ) {
				target.setIcon( "butterfly-"+(target.getVelX() > 0 ? "e" : "w") );
				flapFrame = false;
			}
			if( flap ) {
				double newVx = Math.random()-0.5;
				target.setIcon( "butterfly-"+(newVx > 0 ? "e" : "w")+"-flap" );
				target.setVelocity( newVx, Math.random()-0.5, 1.0 );
				timeSinceLastFlap = 0;
				flapFrame = true;
			}
			target.setVelocity( target.getVelX(), target.getVelY(), target.getVelZ()-2.0*interval );
		}
	}
	
	public static class Jumpy implements Behavior {
		Behavable target;
		public Jumpy( Behavable target ) {
			this.target = target;
		}
		public void doStuff(double interval) {
			double z = Math.abs(Math.sin((double)System.currentTimeMillis()/200));
			if( z < 0.1 ) {
				target.setVelocity( Math.random()-0.5, Math.random()-0.5, 0);
			}
			target.setPosition( target.getX(), target.getY(), z );
		}
	}
	
	/*
	protected Section generateSection( String sectionName, String planeName ) {
		String[] scp = sectionName.split(",");
		int sx = Integer.parseInt(scp[0]);
		int sy = Integer.parseInt(scp[1]);
		
		D5_2Perlin basis = new D5_2Perlin();
		basis.setModX(1);
		MultiMultiplyNoise mmn = new MultiMultiplyNoise(
			basis,
			new double[]{
				16, 32, 128,
				8, 16, 96,
				32, 32, 256,
				128, 64, 1024, 
			}
		);
		
		int sectWidth = e2.getSectWidth();
		int sectHeight = e2.getSectHeight();
		
		BasicSection bs = new BasicSection(sectionName, planeName, sectWidth, sectHeight);
		bs.neighborNames[Directions.EAST]      = (sx+1)+","+(sy  );
		bs.neighborNames[Directions.SOUTHEAST] = (sx+1)+","+(sy+1);
		bs.neighborNames[Directions.SOUTH]     = (sx  )+","+(sy+1);
		bs.neighborNames[Directions.SOUTHWEST] = (sx-1)+","+(sy+1);
		bs.neighborNames[Directions.WEST]      = (sx-1)+","+(sy  );
		bs.neighborNames[Directions.NORTHWEST] = (sx-1)+","+(sy-1);
		bs.neighborNames[Directions.NORTH]     = (sx  )+","+(sy-1);
		bs.neighborNames[Directions.NORTHEAST] = (sx+1)+","+(sy-1);
		
		for( int y=bs.getHeight()-1; y>=0; --y ) {
			for( int x=bs.getWidth()-1; x>=0; --x ) {
				String tl;
				double elev = mmn.apply(sx*sectWidth+x,sy*sectHeight+y);
				//double elev = 10*(0.5+basis.apply((sx*sectWidth+x)/64.0,(sy*sectHeight+y)/64.0));
				if( elev > 25.6 ) {
					tl = "grass2";
				} else if( elev > 12.8 ) { 
					tl = "grass1";
				} else if( elev > 6.4 ) { 
					tl = "grass0";
				} else if( elev > 3.2 ) {
					tl = "sand3";
				} else if( elev > 1.6 ) {
					tl = "sand2";
				} else if( elev > 0.8 ) {
					tl = "sand1";
				} else if( elev > 0.0 ) {
					tl = "sand0";
				} else if( elev > -0.1 ) {
					tl = "water0";
				} else if( elev > -0.2 ) {
					tl = "water0";
				} else if( elev > -0.4 ) {
					tl = "water0";
				} else if( elev > -0.8 ) {
					tl = "water1";
				} else if( elev > -1.6 ) {
					tl = "water2";
				} else if( elev > -3.2 ) {
					tl = "water3";
				} else if( elev > -6.4 ) {
					tl = "water4";
				} else if( elev > -12.8 ) {
					tl = "water5";
				} else {
					tl = "water6";
				}
				if( Math.random()*Math.min(elev/3,1.0) > 0.9 ) {
					BasicSprite sprite = new BasicSprite(sectionName+"/tree"+x+","+y );
					sprite.collisionFlags = CollisionFlags.SOLID;
					double r = Math.random();
					if( r < 0.3 ) {
						sprite.iconName = "tree2c";
						sprite.boundingBox = new BasicBoundingBox( -0.3, -0.3, 0.3, 0.3 );
					} else if( r < 0.6 ) {
						sprite.iconName = "tree2e";
						sprite.boundingBox = new BasicBoundingBox( -0.3, -0.3, 0.3, 0.3 );
					} else {
						sprite.iconName = "tree1";
						sprite.boundingBox = new BasicBoundingBox( -0.7, -0.4, 0.7, 0.4 );
					}
					sprite.x = x+0.5+(Math.random()-0.5);
					sprite.y = y+0.5+(Math.random()-0.5);
					sprite.putAttribute("shadow-icon-name","shadow128");
					sprite.putAttribute("shadow-offset",new double[]{0.3,-0.25});
					if( r > 0.9 ) {
						sprite.collisionFlags = CollisionFlags.SOLID|CollisionFlags.MOBILE_SOLID;
						sprite.stationary = false;
						sprite.automatic = true;
						sprite.putAttribute("behavior-class-name", Jumpy.class.getName());
					}
					bs.addSprite( sprite );
				}

				BasicSprite butterfly = new BasicSprite(sectionName+"/butterfly1");
				butterfly.automatic = true;
				butterfly.stationary = false;
				butterfly.iconName = "butterfly-e-flap";
				butterfly.x = 32;
				butterfly.y = 32;
				butterfly.z = 1.0;
				butterfly.putAttribute("behavior-class-name", Butterflyish.class.getName());
				bs.addSprite( butterfly );

				butterfly = new BasicSprite(sectionName+"/butterfly2");
				butterfly.automatic = true;
				butterfly.stationary = false;
				butterfly.iconName = "butterfly-e";
				butterfly.x = 24;
				butterfly.y = 32;
				butterfly.z = 1.0;
				butterfly.putAttribute("behavior-class-name", Butterflyish.class.getName());
				bs.addSprite( butterfly );
				
				bs.setTile( x, y, tl );
			}
		}
		return bs;
	}
	*/
	
	public TestGame() {
		super();
		
		int sectWidth = 64, sectHeight = 64;
		
		final String planeName = "default-plane";
		String sectionPrefix = "";
		BasicPlane plane = new BasicPlane(planeName);
		plane.yDepthFactor = 1.0;
		
		D5_2Perlin basis = new D5_2Perlin();
		//basis.setModX(1);
		MultiMultiplyNoise mmn = new MultiMultiplyNoise(
			basis,
			new double[]{
				16, 32, 128,
				8, 16, 96,
				32, 32, 256,
				128, 64, 512, 
			}
		);
		final NoiseSectionGenerator nsg = new NoiseSectionGenerator(planeName, sectionPrefix, sectWidth, sectHeight, mmn);
		nsg.terrainTiles.put("grass2",  32);
		nsg.terrainTiles.put("grass1",  16);
		nsg.terrainTiles.put("grass0",  12);
		nsg.terrainTiles.put("sand3",    8);
		nsg.terrainTiles.put("sand2",    4);
		nsg.terrainTiles.put("sand1",    2);
		nsg.terrainTiles.put("sand0",    1);
		// Water line at 0!
		nsg.terrainTiles.put("water0",  -1);
		nsg.terrainTiles.put("water1",  -2);
		nsg.terrainTiles.put("water2",  -4);
		nsg.terrainTiles.put("water3",  -8);
		nsg.terrainTiles.put("water4", -16);
		nsg.terrainTiles.put("water5", -32);
		nsg.terrainTiles.put("water6", -64);
		
		BasicSprite butterfly = new BasicSprite("butterfly-prototype");
		butterfly.automatic = true;
		butterfly.stationary = false;
		butterfly.iconName = "butterfly-e-flap";
		butterfly.putAttribute("behavior-class-name", Butterflyish.class.getName());
		
		BasicSprite veg = new BasicSprite("tree1-prototype");
		veg.collisionFlags = CollisionFlags.SOLID;
		veg.iconName = "tree1";
		veg.boundingBox = new BasicBoundingBox( -0.7, -0.4, 0.7, 0.4 );
		veg.putAttribute("shadow-icon-name","shadow128");
		veg.putAttribute("shadow-offset",new double[]{0.3,-0.25});
		
		MultiMultiplyNoise vegn = new MultiMultiplyNoise(
			basis,
			new double[]{
				64, 0.4, 128,
				128, 0.4, 256,
			}
		);
		
		final Vegetator vegetator = new Vegetator(sectionPrefix, sectWidth, sectHeight, nsg);
		vegetator.addVegType("soil", vegn, veg);
		vegetator.addVegType("soil", new ConstantDDD(0.0001), butterfly);
		
		final WeakRefCache generatedSectionCache = new WeakRefCache( vegetator );

		final OverlaySectionGenerator osg = new OverlaySectionGenerator(sectWidth, sectHeight, generatedSectionCache);
		
		BasicWorldAccessor bwa = new BasicWorldAccessor() {
			public Section getSection(String sectionName) {
			    return (Section)osg.apply(sectionName);
			}
		};

		bwa.addPlane( plane );
		
		bwa.addImageSheet( new BasicRegularImageSheet("basic-tiles", "images/tiles.png",0,0,32,32,0,0,16));
		bwa.defineSheetTile( "block0", "basic-tiles", 1, CollisionFlags.SOLID );
		bwa.defineSheetTile( "block1", "basic-tiles", 3, CollisionFlags.SOLID );

		bwa.addImageSheet( new BasicRegularImageSheet("outdoor1-tiles", "images/outdoor1.png",0,0,32,32,0,0,16));
		bwa.defineSheetTile( "water6", "outdoor1-tiles",  0, CollisionFlags.WATER, new String[]{"water"} );
		bwa.defineSheetTile( "water5", "outdoor1-tiles",  1, CollisionFlags.WATER, new String[]{"water"} );
		bwa.defineSheetTile( "water4", "outdoor1-tiles",  2, CollisionFlags.WATER, new String[]{"water"} );
		bwa.defineSheetTile( "water3", "outdoor1-tiles",  3, CollisionFlags.WATER, new String[]{"water"} );
		bwa.defineSheetTile( "water2", "outdoor1-tiles",  4, CollisionFlags.WATER, new String[]{"water"} );
		bwa.defineSheetTile( "water1", "outdoor1-tiles",  5, CollisionFlags.WATER, new String[]{"water"} );
		bwa.defineSheetTile( "water0", "outdoor1-tiles",  6, CollisionFlags.WATER|CollisionFlags.LAND, new String[]{"water"} );
		bwa.defineSheetTile( "sand0",  "outdoor1-tiles",  7, CollisionFlags.LAND );
		bwa.defineSheetTile( "sand1",  "outdoor1-tiles",  8, CollisionFlags.LAND, new String[]{"soil"} );
		bwa.defineSheetTile( "sand2",  "outdoor1-tiles",  9, CollisionFlags.LAND, new String[]{"soil"} );
		bwa.defineSheetTile( "sand3",  "outdoor1-tiles", 10, CollisionFlags.LAND, new String[]{"soil"} );
		bwa.defineSheetTile( "grass0", "outdoor1-tiles", 16, CollisionFlags.LAND, new String[]{"soil","grass"} );
		bwa.defineSheetTile( "grass1", "outdoor1-tiles", 17, CollisionFlags.LAND, new String[]{"soil","grass"} );
		bwa.defineSheetTile( "grass2", "outdoor1-tiles", 18, CollisionFlags.LAND, new String[]{"soil","grass"} );
		bwa.defineSheetTile( "dirt0",  "outdoor1-tiles", 20, CollisionFlags.LAND, new String[]{"soil"} );

		bwa.defineImage( "tree1", "images/tree1.png" );
		bwa.defineIcon( "tree1", -64, -114 );
		
		bwa.defineImage( "tree2c", "images/tree2c.png" );
		bwa.defineIcon( "tree2c", -63, -116 );
		
		bwa.defineImage( "tree2e", "images/tree2e.png" );
		bwa.defineIcon( "tree2e", -56, -146 );

		bwa.defineImage( "shadow128", "images/shadow128.png" );
		bwa.defineIcon( "shadow128", -64, -20 );
		
		bwa.defineImage( "butterfly-e", "images/butterfly.png", "x" );
		bwa.defineImage( "butterfly-w", "images/butterfly.png" );
		bwa.defineImage( "butterfly-e-flap", "images/butterfly-flap.png", "x" );
		bwa.defineImage( "butterfly-w-flap", "images/butterfly-flap.png" );
		bwa.defineIcon( "butterfly-e", -8, -8 );
		bwa.defineIcon( "butterfly-w", -8, -8 );
		bwa.defineIcon( "butterfly-e-flap", -8, -8 );
		bwa.defineIcon( "butterfly-w-flap", -8, -8 );
		
		FunctionOO tilesFunc = new MapFunction(bwa.tiles);
		
		vegetator.tiles = tilesFunc;
		osg.tiles = tilesFunc;
		PathCreator pc1 = new PathCreator(osg);
		pc1.createPath(4000);
		PathCreator pc2 = new PathCreator(osg);
		pc2.dir = Math.PI;
		pc2.createPath(4000);

		this.e2 = new JGameTG2Engine( this, bwa );

		initEngineApplet();
	}
	
	public TestGame(JGPoint size) {
		initEngine(size.x,size.y); 
	}
	
	////
	
	
	////
	
	public void initCanvas() {
		setCanvasSettings(
				20,	15, // Screen width (in tiles)
				32, 32, // Tile size
				null,
				null,
				null
			);
		this.zYFactor = -32.0;
		setFrameRate( 60, 4 );
	}
	
	protected class Man extends JGObject {
		// Is blocked by any of these
		public int blockMask = CollisionFlags.MOBILE_SOLID|CollisionFlags.SOLID;
		// Can pass on any of these, assuming not blocked:
		public int passMask = CollisionFlags.LAND;
		
		public JGObject shadow;
		public Man( String name, boolean autoName, double x, double y, int collisionid, String imagename, int iox, int ioy, float depth, JGRectangle bbox ) {
			super( name, autoName, x, y, collisionid, imagename );
			this.imageOffsetX = iox;
			this.imageOffsetY = ioy;
			this.depth = depth;
			this.bbox = bbox;
		}
		public Man( String name, boolean autoName, double x, double y, int collisionid, String imagename, int iox, int ioy, float baseDepth, int bbx, int bby, int bbw, int bbh ) {
			this( name, autoName, x, y, collisionid, imagename, iox, ioy, baseDepth, new JGRectangle(bbx,bby,bbw,bbh) );
		}
		protected boolean isBlockedBy(int cid) {
			return (cid & blockMask) != 0;
		}
		protected boolean canPassOver(int cid) {
			return (cid & passMask) != 0;
		}
		protected boolean canPassBG(int cid) {
			return !isBlockedBy(cid) && canPassOver(cid);
		}
		public void hit_bg(int tilecid) {
			double newX = this.getLastX();
			double newY = this.getLastY();
			if( canPassBG(checkBGCollision(0,-yspeed)) ) {
				newX = this.x;
			}
			if( canPassBG(checkBGCollision(-xspeed,0)) ) {
				newY = this.y;
			}
			this.x = newX;
			this.y = newY;
		}
		public void hit(JGObject obj) {
			double newX = this.getLastX();
			double newY = this.getLastY();
			if( !isBlockedBy(checkCollision(obj.colid,0,-yspeed)) ) {
				newX = this.x;
			}
			if( !isBlockedBy(checkCollision(obj.colid,-xspeed,0)) ) {
				newY = this.y;
			}
			this.x = newX;
			this.y = newY;
		}
		public void postUpdate() {
			if( this.shadow != null ) {
				this.shadow.x = round2(this.x);
				this.shadow.y = round2(this.y);
			}
		}
	}
	
	Man greenFace;
	Man redFace;
	Man redMan;
	
	public class PathCreator {
		WorldTileAccessor wta;
		public int width = 2 ;
		public int height = 2;
		public String pathTile = "dirt0";
		public String borderTile = "block0";
		public String[] borderWhenTag = new String[]{"water"};
		public int x;
		public int y;
		public double dir = 0.0;
		public double dirChange = 0.0;
		public double maxDirChange = 0.03;
		public double dirCD = 0.02;
		public double tendTowards = 0.5;
		public double tendTowardsChange = 0.005;
		
		public PathCreator( WorldTileAccessor wta ) {
			this.wta = wta;
		}
		
		protected void borderTile( int x, int y ) {
			Set tags = wta.getTileTagsAt(x, y);
			for( int i=0; i<borderWhenTag.length; ++i ) {
				if( tags.contains(borderWhenTag[i]) ) {
					wta.setTileAt( x, y, borderTile );
					return;
				}
			}
		}
		
		protected void createPath( int steps ) {
			while( steps > 0 ) {
				int sx = x-(width/2);
				int sy = y-(height/2);
				
				wta.removeSpritesNear( x, y, (int)Math.ceil(Math.max(width, height)/(double)2)+1 );
				
				for( int dy=0; dy<height; ++dy ) {
					for( int dx=0; dx<width; ++dx ) {
						wta.setTileAt( sx+dx, sy+dy, pathTile );
					}
				}
				for( int dx=0; dx<width; ++dx ) {
					borderTile( sx+dx, sy-1 );
					borderTile( sx+dx, sy+height );
				}
				for( int dy=0; dy<height; ++dy ) {
					borderTile( sx-1, sy+dy );
					borderTile( sx+width, sy+dy );
				}
				
				int xdir = Math.cos(dir) > 0 ? 1 : -1;
				int ydir = Math.sin(dir) > 0 ? 1 : -1;
				
				x += (Math.random() < Math.abs(Math.cos(dir))) ? xdir : 0;
				y += (Math.random() < Math.abs(Math.sin(dir))) ? ydir : 0;
				dirChange = Math.max(-maxDirChange, Math.min(maxDirChange, dirChange+(Math.random()-0.5)*dirCD));
				dir += dirChange;
				
				if( dir < 0 ) dir += 2*Math.PI;
				if( dir > 2*Math.PI ) dir -= 2*Math.PI;
				
				if( Math.abs(tendTowards - dir) < Math.PI ) {
					if( tendTowards > dir ) {
						dir += tendTowardsChange;
					} else {
						dir -= tendTowardsChange;
					}
				} else {
					if( tendTowards > dir ) {
						dir -= tendTowardsChange;
					} else {
						dir += tendTowardsChange;
					}					
				}
				--steps;
			}
		}
	}
	
	protected static int ROUND2 = ~1;
	protected static double round2( double v ) {
		return (double)( ROUND2 & (int)v );
	}
	
	public void initGame() {
		defineImage( "shadow128", null, 0, "images/shadow128.gif", "" );
		defineImage( "shadow32",  null, 0, "images/shadow32.gif", "" );
		
		defineImageMap( "redman", "images/redman.png", 1, 1, 30, 62, 2, 2);
		defineImage( "redman_ss",  null,  1, "redman",  0, "" );
		defineImage( "redman_ws1", null,  1, "redman",  4, "" );
		defineImage( "redman_ws2", null,  1, "redman",  8, "" );
		defineImage( "redman_ws3", null,  1, "redman", 12, "" );
		defineImage( "redman_we1", null,  1, "redman",  5, "" );
		defineImage( "redman_we2", null,  1, "redman",  9, "" );
		defineImage( "redman_we3", null,  1, "redman", 13, "" );
		defineImage( "redman_wn1", null,  1, "redman",  6, "" );
		defineImage( "redman_wn2", null,  1, "redman", 10, "" );
		defineImage( "redman_wn3", null,  1, "redman", 14, "" );
		defineImage( "redman_ww1", null,  1, "redman",  7, "" );
		defineImage( "redman_ww2", null,  1, "redman", 11, "" );
		defineImage( "redman_ww3", null,  1, "redman", 15, "" );
		defineAnimation( "redman_ws", new String[]{"redman_ws1","redman_ws2","redman_ws3","redman_ws2"}, 0.1);
		defineAnimation( "redman_we", new String[]{"redman_we1","redman_we2","redman_we3","redman_we2"}, 0.1);
		defineAnimation( "redman_wn", new String[]{"redman_wn1","redman_wn2","redman_wn3","redman_wn2"}, 0.1);
		defineAnimation( "redman_ww", new String[]{"redman_ww1","redman_ww2","redman_ww3","redman_ww2"}, 0.1);
	}
	
	public void doFrame() {
		if( redMan == null ) {
			e2.focus("0,0", 32, 32);
			redMan = new Man(JGameTG2Engine.PFX_DYNAMIC_AUTO + "redman", false, 32*e2.getSectWidth()/2, 32*e2.getSectHeight()/2, CollisionFlags.MOBILE_SOLID, "redman_ss", -15, -58, 0, -10, -4, 20 , 8 );
			redMan.shadow = new Man("redman-shadow", false, 0, 0, CollisionFlags.VOID, "shadow32", -12, -10, -8, null );
			
			/*
			// Test performance of repopulating:
			e2.focus(redMan);
			redMan.x = 2000;
			e2.focus(redMan);
			redMan.x = 4000;
			e2.focus(redMan);
			System.exit(0);
			*/
		}

		int ydir = 0;
		int xdir = 0;
		
		if( getKey(KeyDown)  ) ydir += 1;
		if( getKey(KeyUp)    ) ydir -= 1;
		if( getKey(KeyLeft)  ) xdir -= 1;
		if( getKey(KeyRight) ) xdir += 1;
		redMan.xspeed = xdir*4;
		redMan.yspeed = ydir*4;
		if( xdir > 0 ) {
			redMan.setAnim("redman_we");
		} else if( xdir < 0 ) {
			redMan.setAnim("redman_ww");
		} else if( ydir < 0 ) {
			redMan.setAnim("redman_wn");
		} else if( ydir > 0 ) {
			redMan.setAnim("redman_ws");
		} else {
			redMan.setImage("redman_ss");
		}
		
		super.doFrame();
		moveObjects( JGameTG2Engine.PFX_DYNAMIC, 0 );
		checkCollision( CollisionFlags.MOBILE_SOLID|CollisionFlags.SOLID, 1 );
		checkBGCollision( CollisionFlags.SOLID, CollisionFlags.LAND, 1 );
		postUpdateObjects( JGameTG2Engine.PFX_DYNAMIC, 0);
		
		e2.focus(redMan);
	}
	
	public static void main(String[] args) {
		TestGame tg = new TestGame();
		tg.initEngine(640, 480);
		//tg.initEngine(1024, 768);
	}
}
