package togos.game2.data;

import java.util.HashMap;

public class DimensionalBuffer
{
	class WrongLayerType extends RuntimeException {
		public WrongLayerType(String message) {
			super(message);
		}
	}
	
	public DimensionalBuffer( int w, int h, int d ) {
		this.width = w;
		this.height = h;
		this.depth = d;
	}
	public DimensionalBuffer( int w, int h ) {
		this( w, h, 1 );
	}
	public DimensionalBuffer( int w ) {
		this( w, 1, 1 );
	}
	
	protected int width=1;
	protected int height=1;
	protected int depth=1;
	protected HashMap layers = new HashMap(); 
	
	//// Get dimension info ////
	
	public int getWidth() {  return width;  }
	public int getHeight() {  return height;  }
	public int getDepth() {  return depth;  }
	public int getVolume() {  return width*height*depth;  }
	
	//// Get layers ////
	
	public Object getLayer(String name) {
		return layers.get(name);
	}
	
	protected Object getLayerTyped(String name, Class type) {
		Object l = getLayer(name);
		if( l == null ) return null;
		if( type.isAssignableFrom(l.getClass()) ) return l;
		throw new WrongLayerType("Expected "+type.getName()+" for layer "+name+", got "+l.getClass().getName());
	}
	public byte[] getByteLayer(String name) {
		return (byte[])getLayerTyped(name, byte[].class);
	}
	public short[] getShortLayer(String name) {
		return (short[])getLayerTyped(name, short[].class);
	}
	public int[] getIntLayer(String name) {
		return (int[])getLayerTyped(name, int[].class);
	}
	public boolean[] getBitLayer(String name) {
		return (boolean[])getLayerTyped(name, boolean[].class);
	}
	public float[] getFloatLayer(String name) {
		return (float[])getLayerTyped(name, float[].class);
	}
	public Object[] getObjectLayer(String name) {
		return (Object[])getLayerTyped(name, Object[].class);
	}
	
	//// Initialize layers ////
	
	public boolean[] initBitLayer(String name) {
		boolean[] o = new boolean[getVolume()];
		layers.put(name, o);
		return o;
	}
	public boolean[] initBitLayer(String name, boolean fill) {
		boolean[] o = new boolean[getVolume()];
		for( int i=o.length-1; i>=0; --i ) o[i] = fill; 
		layers.put(name, o);
		return o;
	}

	public byte[] initByteLayer(String name) {
		byte[] o = new byte[getVolume()];
		layers.put(name, o);
		return o;
	}
	public byte[] initByteLayer(String name, byte fill) {
		byte[] o = new byte[getVolume()];
		for( int i=o.length-1; i>=0; --i ) o[i] = fill; 
		layers.put(name, o);
		return o;
	}
	
	public short[] initShortLayer(String name) {
		short[] o = new short[getVolume()];
		layers.put(name, o);
		return o;
	}
	public short[] initShortLayer(String name, short fill) {
		short[] o = new short[getVolume()];
		for( int i=o.length-1; i>=0; --i ) o[i] = fill; 
		layers.put(name, o);
		return o;
	}

	public int[] initIntLayer(String name) {
		int[] o = new int[getVolume()];
		layers.put(name, o);
		return o;
	}
	public int[] initIntLayer(String name, int fill) {
		int[] o = new int[getVolume()];
		for( int i=o.length-1; i>=0; --i ) o[i] = fill; 
		layers.put(name, o);
		return o;
	}

	public float[] initFloatLayer(String name) {
		float[] o = new float[getVolume()];
		layers.put(name, o);
		return o;
	}
	public float[] initFloatLayer(String name, float fill) {
		float[] o = new float[getVolume()];
		for( int i=o.length-1; i>=0; --i ) o[i] = fill; 
		layers.put(name, o);
		return o;
	}
	
	public Object[] initObjectLayer(String name) {
		Object[] o = new Object[getVolume()];
		layers.put(name, o);
		return o;
	}
	public Object[] initObjectLayer(String name, Object fill) {
		Object[] o = new Object[getVolume()];
		for( int i=o.length-1; i>=0; --i ) o[i] = fill; 
		layers.put(name, o);
		return o;
	}
}
