package togos.game2.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ValueNameMap
{
	static class Pair implements Comparable {
		public double value;
		public String name;
		
		public Pair( String name, double value ) {
			this.name = name;
			this.value = value;
		}
		
		public int compareTo(Object other) {
			if( ((Pair)other).value < value ) {
				return 1;
			} else if( ((Pair)other).value > value ) {
				return -1;
			} else {
				return 0;
			}
		}
	}
	protected final ArrayList valueNames = new ArrayList();
	protected final HashMap namedValues = new HashMap();
	protected boolean sorted=false;
	
	protected void ensureSorted() {
		if( !sorted ) {
			Collections.sort( valueNames );
			sorted = true;
		}
	}
	
	public void putAll( Map namedValues ) {
		namedValues.putAll( namedValues );
		for( Iterator i=namedValues.entrySet().iterator(); i.hasNext(); ) {
			Map.Entry e = (Map.Entry)i.next();
			valueNames.add( new Pair((String)e.getKey(),((Number)e.getValue()).doubleValue()) );
		}
		if( namedValues.size() > 0 ) sorted = false;
	}
	
	public void put( String name, double value ) {
		namedValues.put( name, new Double(value) );
		valueNames.add( new Pair(name,value) );
		sorted = false;
	}
	
	public double getValue( String name ) {
		return ((Number)namedValues.get(name)).doubleValue();
	}
	
	protected static final double getDist( double x, double y ) {
		return Math.abs(x-y);
	}
	
	protected final int compareDist( double a, double x, double y ) {
		if( x < y ) {
			if( a < x ) return -1;
			if( a > y ) return 1;
		}
		if( y < x ) {
			if( a < y ) return 1;
			if( a > x ) return -1;
		}
		if( getDist(a,x) < getDist(a,y) ) return -1;
		return 1;
	}
	
	protected final double valueAt( int at ) {
		return ((Pair)valueNames.get(at)).value;
	}
	
	protected final String nameAt( int at ) {
		return ((Pair)valueNames.get(at)).name;
	}
	
	protected final String getNameBetween( double value, int first, int last ) {
		// Zero
		if( last < first ) return null;
		
		// One
		if( first == last ) return nameAt(first);
		
		// Two
		if( first+1 == last ) {
			if( compareDist(value,valueAt(first),valueAt(last)) < 1 ) { 
				return nameAt(first);
			} else {
				return nameAt(last);
			}
		}
		
		// More than 2
		int middle = first+(last+1-first)/2;
		if( value < valueAt(middle) ) {
			return getNameBetween( value, first, middle );
		} else {
			return getNameBetween( value, middle, last );
		}
	}
	
	/** Returns the name with the value closest to that given */
	public String getName( double value ) {
		ensureSorted();
		return getNameBetween( value, 0, valueNames.size()-1 );
	}
}
