package togos.game2.data;

import java.lang.ref.WeakReference;
import java.util.HashMap;

import togos.game2.function.FunctionOO;

public class WeakRefCache implements FunctionOO
{
	HashMap weakRefsToStuff = new HashMap();
	FunctionOO generator;
	
	public WeakRefCache(FunctionOO generator) {
		this.generator = generator;
	}
	
	public Object apply(Object arg0) {
		WeakReference vr = (WeakReference)weakRefsToStuff.get(arg0);
		Object v;
		if( vr == null || (v = vr.get()) == null ) {
			v = generator.apply(arg0);
			weakRefsToStuff.put( arg0, new WeakReference(v) );
		}
	    return v;
	}
}
