package togos.game2.world.accessor;

import java.util.HashMap;
import java.util.Map;

import togos.game2.function.FunctionOV;
import togos.game2.world.definitions.Icon;
import togos.game2.world.definitions.Image;
import togos.game2.world.definitions.ImageOrAnimation;
import togos.game2.world.definitions.ImageSheet;
import togos.game2.world.definitions.Plane;
import togos.game2.world.definitions.Section;
import togos.game2.world.definitions.Tile;
import togos.game2.world.definitions.impl.BasicDirectImage;
import togos.game2.world.definitions.impl.BasicIcon;
import togos.game2.world.definitions.impl.BasicSheetImage;
import togos.game2.world.definitions.impl.BasicTile;

public class BasicWorldAccessor implements WorldAccessor
{
	public Map icons = new HashMap();
	public Map images = new HashMap();
	public Map imageSheets = new HashMap();
	public Map planes = new HashMap();
	public Map sections = new HashMap();
	public Map tiles = new HashMap();
	
	public void addImageSheet( ImageSheet is ) {
		imageSheets.put(is.getSheetName(), is);
	}
	public void addImage( Image i ) {
		images.put(i.getImageName(), i);
	}
	public void addTile( Tile t ) {
		tiles.put(t.getTileName(), t);
	}
	public void addSection( Section s ) {
		sections.put(s.getSectionName(), s);
	}
	public void addPlane( Plane p ) {
		planes.put(p.getPlaneName(), p);
	}
	public void addIcon( Icon i ) {
		icons.put(i.getIconName(), i);
	}

	/**
	 * Shortcut for defining a tile and a sheet image at once
	 * @param name name of both tile and image
	 * @param sheetName name of image sheet
	 * @param sIdx index within sheet
	 * @param cFlags collision flags for tile
	 */
	public BasicTile defineSheetTile( String name, String sheetName, int sIdx, int cFlags ) {
		addImage( new BasicSheetImage(name, sheetName, sIdx) );
		BasicTile t = new BasicTile(name, name, cFlags);
		addTile( t );
		return t;
	}
	
	public BasicTile defineSheetTile( String name, String sheetName, int sIdx, int cFlags, String[] tags ) {
		BasicTile t = defineSheetTile( name, sheetName, sIdx, cFlags );
		if( tags != null ) {
			for( int i=tags.length-1; i>=0; --i ) {
				t.addTag(tags[i]);
			}
		}
		return t;
	}
	
	public void defineImage( String name, String uri ) {
		addImage( new BasicDirectImage(name, uri, ""));
	}
	
	public void defineImage( String name, String uri, String op ) {
		addImage( new BasicDirectImage(name, uri, op));
	}
	
	public void defineIcon( String name, int ox, int oy ) {
		addIcon( new BasicIcon( name, name, ox, oy, 0 ) );
	}
	
	////
	
	public Icon getIcon(String name) {
		return (Icon)icons.get(name);
	}

	public ImageOrAnimation getImage(String name) {
		return (ImageOrAnimation)images.get(name);
	}

	public ImageSheet getImageSheet(String name) {
		return (ImageSheet)imageSheets.get(name);
	}

	public Plane getPlane(String name) {
		return (Plane)planes.get(name);
	}

	public Section getSection(String name) {
		return (Section)sections.get(name);
	}

	public Tile getTile(String name) {
		return (Tile)tiles.get(name);
	}

	public void preloadPlane(String name, FunctionOV onload) {
	}

	public void preloadSection(String name, FunctionOV onload) {
	}
}
