package togos.game2.world.accessor;

import togos.game2.function.FunctionOV;
import togos.game2.world.definitions.Icon;
import togos.game2.world.definitions.ImageOrAnimation;
import togos.game2.world.definitions.ImageSheet;
import togos.game2.world.definitions.Plane;
import togos.game2.world.definitions.Section;
import togos.game2.world.definitions.Tile;

/**
 * Defines attributes that must be global to an entire game
 */
public interface WorldAccessor
{
	public Plane getPlane(String name);
	public Section getSection(String name);
	public Tile getTile(String name);
	public ImageSheet getImageSheet(String name);
	public Icon getIcon(String name);
	public ImageOrAnimation getImage(String name);

	public void preloadPlane(String name, FunctionOV onload);
	public void preloadSection(String name, FunctionOV onload);
}
