package togos.game2.world.constants;

public class Directions
{
	public static final int EAST = 0;
	public static final int SOUTHEAST = 1;
	public static final int SOUTH = 2;
	public static final int SOUTHWEST = 3;
	public static final int WEST = 4;
	public static final int NORTHWEST = 5;
	public static final int NORTH = 6;
	public static final int NORTHEAST = 7;
	
	public static final int[] directionToXY( int dir ) {
		switch( dir ) {
		case 0: return new int[]{  1, 0 };
		case 1: return new int[]{  1, 1 };
		case 2: return new int[]{  0, 1 };
		case 3: return new int[]{ -1, 1 };
		case 4: return new int[]{ -1, 0 };
		case 5: return new int[]{ -1,-1 };
		case 6: return new int[]{  0,-1 };
		case 7: return new int[]{  1,-1 };
		default:
			throw new RuntimeException("Invalid direction: "+dir);
		}
	}
	
	public static final int xyToDirection( int x, int y ) {
		switch( x ) {
		case  1:
			switch( y ) {
			case  1: return SOUTHEAST;
			case  0: return EAST;
			case -1: return NORTHEAST;
			default: throw new RuntimeException("Invalid xy for direction: "+x+","+y);
			}
		case  0:
			switch( y ) {
			case  1: return SOUTH;
			case -1: return NORTH;
			default: throw new RuntimeException("Invalid xy for direction: "+x+","+y);
			}
		case -1:
			switch( y ) {
			case  1: return SOUTHWEST;
			case  0: return WEST;
			case -1: return NORTHWEST;
			default: throw new RuntimeException("Invalid xy for direction: "+x+","+y);
			}
		default: throw new RuntimeException("Invalid xy for direction: "+x+","+y);
		}
	}
}
