package togos.game2.world.definitions;

/**
 * Attributes that must be constant across spatially contiguous sections.
 */
public interface Plane
{
	public String getPlaneName();
	
	/** Dimensions of tiles and units, in pixels */
	public int getTileWidth();
	public int getTileHeight();
	public double getUnitWidth();
	public double getUnitHeight();
	/**
	 * How much should an object's Y position affect its depth on the screen?
	 * Usually 1.0 for birds-eye views, 0 for straight-on views.
	 */
	public double getYDepthFactor();
	/**
	 * How much should something +z in the world look +y on the screen,
	 * NOT premultiplied by unit height.
	 */
	public double getZYFactor();
}
