package togos.game2.world.definitions;

/**
 * Defines a 'sheet' of images in a regularly spaced matrix
 * (i.e., compatible with JGame's imagemap/spritesheets
 */
public interface RegularImageSheet extends ImageSheet
{
	public int getFirstX();
	public int getFirstY();
	public int getCellWidth();
	public int getCellHeight();
	public int getSkipX();
	public int getSkipY();
	/**
	 * How many cells wide?
	 * Note that JGame figures this by looking at
	 * actual image date, so this *must* match
	 * how many cells actually fit across!
	 * */
	public int getWidth();
}
