package togos.game2.world.definitions;

public interface Sprite extends Tagged, Attributed
{
	/**
	 * Globally unique name of the sprite.
	 */
	public String getSpriteName();
	
	/** Return true if this sprite's position cannot change */
	public boolean isStationary();
	/** Return true if this sprite can collide/be collided with */
	public boolean isPhysical();
	/** Return true if this sprite can moved in such a way
	 * that collision detection must be applied to its path */
	public boolean isMobile();
	/** Return true if we don't need to worry about losing this object's
	 * state when it is far away from the player */
	public boolean isResettable();
	/** Return true if this sprite moves by itself */
	public boolean isAutomatic();
	
	public int getCollisionFlags();
	
	public String getIconName();
	/** Return x,y position *within section* in section units */
	public double getX();
	public double getY();
	public double getZ();
	
	/** Only needed for physical sprites */
	public BoundingBox getBoundingBox();
}
