package togos.game2.world.definitions.impl;

import java.util.ArrayList;
import java.util.Collection;

import togos.game2.world.definitions.Section;
import togos.game2.world.definitions.Sprite;

public class BasicSection implements togos.game2.world.definitions.Section
{
	public String sectionName, planeName;
	public int width, height;
	public String[] tileNames;
	public String[] neighborNames = new String[9];
	public Collection sprites = new ArrayList();
	
	public BasicSection( String sectionName, String planeName, int width, int height ) {
		this.sectionName = sectionName;
		this.planeName = planeName;
		this.width = width;
		this.height = height;
		tileNames = new String[width*height];
	}
	
	public BasicSection( Section cloneFrom, boolean cloneTiles, boolean cloneSprites ) {
		this.sectionName = cloneFrom.getSectionName();
		this.planeName = cloneFrom.getPlaneName();
		this.width = cloneFrom.getWidth();
		this.height = cloneFrom.getHeight();
		for( int i=0; i<8; ++i ) {
			this.neighborNames[i] = cloneFrom.getNeighborName(i);
		}
		
		if( cloneTiles ) {
			String[] oldTiles = cloneFrom.getTileNames();
			this.tileNames = new String[width*height];
			for( int i=oldTiles.length; i>=0; --i ) {
				tileNames[i] = oldTiles[i];
			}
		} else {
			this.tileNames = cloneFrom.getTileNames();
		}
		
		if( cloneSprites ) {
			this.sprites = new ArrayList(cloneFrom.getSprites());
		} else {
			this.sprites = cloneFrom.getSprites();
		}
	}

	public String getPlaneName() {  return planeName;  }
	public String getSectionName() {  return sectionName;  }

	public int getWidth() {  return width;  }
	public int getHeight() {  return height;  }

	public String getNeighborName(int neighborNumber) {
		return neighborNames[neighborNumber];
	}

	public Collection getSprites() {
		return sprites;
	}

	public String[] getTileNames() {
		return tileNames;
	}
	
	public void setTile( int x, int y, String tileName ) {
		tileNames[x+y*width] = tileName;
	}
	
	public void addSprite( Sprite s ) {
		sprites.add(s);
	}
}
