package togos.game2.world.definitions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import togos.game2.world.definitions.BoundingBox;
import togos.game2.world.definitions.Sprite;

public class BasicSprite implements Sprite
{
	protected String spriteName;
	protected Set tags = Collections.EMPTY_SET;
	protected Map attributes = Collections.EMPTY_MAP;
	public BoundingBox boundingBox;
	public String iconName;
	public int collisionFlags;
	public double x, y, z;

	protected boolean tagsReadOnly = true;
	protected boolean attributesReadOnly = true;
	
	public boolean stationary = true;
	public boolean resettable = true;
	public boolean mobile = false;
	public boolean physical = false;
	public boolean automatic = false;

	public BasicSprite( String spriteName ) {
		this.spriteName = spriteName;
	}
	
	public BasicSprite( String spriteName, Sprite cloneFrom, double x, double y, double z ) {
		this(spriteName);
		this.setTags( cloneFrom.getTags() );
		this.setAttributes( cloneFrom.getAttributes() );
		this.boundingBox = cloneFrom.getBoundingBox();
		this.iconName = cloneFrom.getIconName();
		this.collisionFlags = cloneFrom.getCollisionFlags();
		this.x = x;
		this.y = y;
		this.z = z;
		this.stationary = cloneFrom.isStationary();
		this.resettable = cloneFrom.isResettable();
		this.mobile = cloneFrom.isMobile();
		this.physical = cloneFrom.isPhysical();
		this.automatic = cloneFrom.isAutomatic();
	}
	
	public BasicSprite( String spriteName, Sprite cloneFrom ) {
		this(spriteName, cloneFrom, cloneFrom.getX(), cloneFrom.getY(), cloneFrom.getZ());
	}
	
	////
	
	public String getSpriteName() {  return spriteName;  }
	public Set getTags() {  tagsReadOnly = true; return tags;  }
	public Map getAttributes() {  attributesReadOnly = true;  return attributes;  }
	public BoundingBox getBoundingBox() {  return boundingBox;  }
	public int getCollisionFlags() {  return collisionFlags;  }
	public String getIconName() {  return iconName;  }
	public double getX() {  return x;  }
	public double getY() {  return y;  }
	public double getZ() {  return z;  }
	public boolean isAutomatic() {  return automatic;  }
	public boolean isMobile() {  return mobile;  }
	public boolean isPhysical() {  return physical;  }
	public boolean isResettable() {  return resettable;  }
	public boolean isStationary() {  return stationary;  }
	
	////
	
	public void setTags( Set tags ) {
		this.tags = tags;
		tagsReadOnly = true;
	}
	public void addTag( String tag ) {
		if( tagsReadOnly ) {
			tags = new HashSet(tags);
			tagsReadOnly = false;
		}
		tags.add(tag);
	}
	
	public void setAttributes( Map attributes ) {
		this.attributes = attributes;
		attributesReadOnly = true;
	}
	public void putAttribute( String key, Object value ) {
		if( tagsReadOnly ) {
			attributes = new HashMap(attributes);
			attributesReadOnly = false;
		}
		attributes.put( key, value );
	}
	
	/*
	public Object clone() throws CloneNotSupportedException {
		// TODO: Will need to make new name for it, too!
		tagsReadOnly = true;
		attributesReadOnly = true;
		return super.clone();
	}
	*/
}
