package togos.game2.world.definitions.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BasicTile implements togos.game2.world.definitions.Tile
{
	public int collisionFlags = 0;
	public String imageName = null;
	public Set tags = Collections.EMPTY_SET;
	public String tileName;
	
	public BasicTile( String tileName ) {
		this.tileName = tileName;
	}
	public BasicTile( String tileName, String imageName, int collisionFlags ) {
		this.tileName = tileName;
		this.imageName = imageName;
		this.collisionFlags = collisionFlags;
	}
	
	public String getTileName() {  return tileName;  }
	public int getCollisionFlags() {  return collisionFlags;  }
	public String getImageName() {  return imageName;  }
	
	public Set getTags() {  return tags;  }
	
	public void addTag(String tag) {
		if( tags == Collections.EMPTY_SET ) {
			tags = new HashSet();
		}
		tags.add(tag);
	}
}
