package togos.game2.worldgen;

import togos.game2.data.ValueNameMap;
import togos.game2.function.FunctionDDD;
import togos.game2.function.FunctionOO;
import togos.game2.world.constants.Directions;
import togos.game2.world.definitions.impl.BasicSection;

public class NoiseSectionGenerator implements FunctionOO
{
	public String planeName = "default-plane";
	public String sectionPrefix = "";
	public FunctionDDD terrainFunction;
	public ValueNameMap terrainTiles = new ValueNameMap();
	public int sectionWidth,sectionHeight;
	
	public NoiseSectionGenerator( String planeName, String pfx, int sw, int sh, FunctionDDD terrainFunction ) {
		this.planeName = planeName;
		this.sectionPrefix = pfx;
		this.sectionWidth = sw;
		this.sectionHeight = sh;
		this.terrainFunction = terrainFunction;
	}
	
	protected String getTileAt( int wx, int wy ) {
		return terrainTiles.getName( terrainFunction.apply(wx+0.5, wy+0.5) );
	}
	
	public Object apply(Object arg0) {
		String sectionName = (String)arg0;
	    int[] xy = WGUtil.parseSectionOffset(sectionName.substring(sectionPrefix.length()), 2);
		int sx = xy[0], sy = xy[1];
		
		BasicSection bs = new BasicSection(sectionName, planeName, sectionWidth, sectionHeight);
		bs.neighborNames[Directions.EAST]      = sectionPrefix+(sx+1)+","+(sy  );
		bs.neighborNames[Directions.SOUTHEAST] = sectionPrefix+(sx+1)+","+(sy+1);
		bs.neighborNames[Directions.SOUTH]     = sectionPrefix+(sx  )+","+(sy+1);
		bs.neighborNames[Directions.SOUTHWEST] = sectionPrefix+(sx-1)+","+(sy+1);
		bs.neighborNames[Directions.WEST]      = sectionPrefix+(sx-1)+","+(sy  );
		bs.neighborNames[Directions.NORTHWEST] = sectionPrefix+(sx-1)+","+(sy-1);
		bs.neighborNames[Directions.NORTH]     = sectionPrefix+(sx  )+","+(sy-1);
		bs.neighborNames[Directions.NORTHEAST] = sectionPrefix+(sx+1)+","+(sy-1);
		
	    int swx = xy[0]*sectionWidth;
	    int swy = xy[1]*sectionHeight;
	    for( int y=sectionHeight-1; y>=0; --y ) {
	    	for( int x=sectionWidth-1; x>=0; --x ) {
	    		bs.setTile(x, y, getTileAt(x+swx,y+swy) );
	    	}
	    }
	    
	    return bs;
	}
}
