package togos.game2.worldgen;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import togos.game2.function.FunctionOO;
import togos.game2.world.definitions.Section;
import togos.game2.world.definitions.Sprite;
import togos.game2.world.definitions.Tile;

public class OverlaySectionGenerator implements FunctionOO, WorldTileAccessor
{
	protected FunctionOO backingSectionGenerator;
	protected Map dirtySections = new HashMap();
	protected int sectionWidth, sectionHeight;
	public FunctionOO tiles;
	
	public OverlaySectionGenerator( int sw, int sh, FunctionOO backingSectionGenerator ) {
		this.sectionWidth = sw;
		this.sectionHeight = sh;
		this.backingSectionGenerator = backingSectionGenerator;

	}
	
	protected Section getDirtySection( String sectionName ) {
		Section s = (Section)dirtySections.get(sectionName);
		if( s == null ) {
			s = (Section)backingSectionGenerator.apply(sectionName);
			dirtySections.put(sectionName, s);
		}
		return s;
	}
	
	protected final static int floorify(int x, int mod) {
		return (int)Math.floor(x/(double)mod);
	}
	
	protected final String getNameOfSectionAt( int wx, int wy ) {
		return floorify(wx,sectionWidth) + "," + floorify(wy,sectionHeight);
	}
	
	protected final static int tmod( int x, int d ) {
		if( x < 0 ) return (d-((-x)%d))%d;
		return x%d;
	}
	
	public String getTileAt( int wx, int wy ) {
		Section s = (Section)apply( getNameOfSectionAt(wx,wy) );
		int x = tmod(wx,sectionWidth);
		int y = tmod(wy,sectionHeight);
		if( x+y*sectionWidth > 4096 ) {
			System.err.println("wtf");
		}
		return s.getTileNames()[x+y*sectionWidth];
	}
	
	public void setTileAt( int wx, int wy, String tileName ) {
		Section s = getDirtySection( getNameOfSectionAt(wx,wy) );
		int x = tmod(wx,sectionWidth);
		int y = tmod(wy,sectionHeight);
		s.getTileNames()[x+y*sectionWidth] = tileName;
	}
	
	public void removeSpritesNear( int wx, int wy, int radius ) {
		Section s = getDirtySection( getNameOfSectionAt(wx,wy) );
		int x = tmod(wx,sectionWidth);
		int y = tmod(wy,sectionHeight);
		for( Iterator i = s.getSprites().iterator(); i.hasNext(); ) {
			Sprite sprite = (Sprite)i.next();
			if( Math.abs(sprite.getX()-x) < radius && Math.abs(sprite.getY()-y) < radius ) {
				i.remove();
			}
		}
		
	}
	
	public Set getTileTagsAt( int wx, int wy ) {
		Tile t = (Tile)tiles.apply( getTileAt(wx,wy) ); 
		return t == null ? Collections.EMPTY_SET : t.getTags();
	}
	
	public Object apply(Object sectionName) {
		Section s = (Section)dirtySections.get(sectionName);
		if( s != null ) return s;
		if( backingSectionGenerator != null ) return backingSectionGenerator.apply(sectionName);
		return null;
	}
}
