package togos.game2.worldgen;

import java.util.ArrayList;

import togos.game2.data.ValueNameMap;
import togos.game2.function.FunctionDDD;
import togos.game2.function.FunctionOO;
import togos.game2.world.definitions.Section;
import togos.game2.world.definitions.Sprite;
import togos.game2.world.definitions.Tile;
import togos.game2.world.definitions.impl.BasicSection;
import togos.game2.world.definitions.impl.BasicSprite;

public class Vegetator implements FunctionOO
{
	public static class VegType {
		public String growsOnTag = "soil";
		public Sprite cloneSprite;		
		public FunctionDDD densityFunction;
		
		public VegType( String growsOn, FunctionDDD density, Sprite cloneSprite ) {
			this.growsOnTag = growsOn;
			this.densityFunction = density;
			this.cloneSprite = cloneSprite;
		}
	}
	
	ArrayList vegTypes = new ArrayList();
	
	public void addVegType( String growsOn, FunctionDDD density, Sprite cloneSprite ) {
		vegTypes.add( new VegType(growsOn,density,cloneSprite) );
	}
	
	FunctionOO backingSectionGenerator;
	public String sectionPrefix = "";
	public ValueNameMap terrainTiles = new ValueNameMap();
	public FunctionOO tiles;
	public int sectionWidth,sectionHeight;
	
	protected int blockSize=16;

	public Vegetator( String pfx, int sw, int sh, FunctionOO backingSectionGenerator ) {
		this.sectionPrefix = pfx;
		this.sectionWidth = sw;
		this.sectionHeight = sh;
		this.backingSectionGenerator = backingSectionGenerator;
	}
	public Object apply(Object arg0) {
		String sectionName = (String)arg0;
	    int[] xy = WGUtil.parseSectionOffset(sectionName.substring(sectionPrefix.length()), 2);
		int sx = xy[0], sy = xy[1];
		double swx=(double)sx*sectionWidth, swy=(double)sy*sectionHeight;
		
		int vegCount = 0;
		BasicSection bs = new BasicSection((Section)backingSectionGenerator.apply(arg0), false, true);
		for( int by=blockSize/2; by<bs.getHeight(); by+=blockSize ) {
			for( int bx=blockSize/2; bx<bs.getWidth(); bx+=blockSize ) {
				double bwx=bx+swx, bwy=by+swy;
				for( int vti=vegTypes.size()-1; vti>=0; --vti ) {
					VegType vt = (VegType)vegTypes.get(vti);
					double count = Math.min(1,vt.densityFunction.apply(bwx, bwy))*blockSize*blockSize;
					if( count > 0 && count < 1 ) {
						count = Math.random() < count ? 1 : 0;
					}
					for( int i=0; i<count; ++i ) {
						double spriteX = (Math.random()-0.5)*blockSize+bx;
						double spriteY = (Math.random()-0.5)*blockSize+by;
						String tileName = bs.tileNames[(int)spriteX+(int)spriteY*bs.getWidth()];
						Tile tile = (Tile)tiles.apply(tileName);
						if( tile != null && tile.getTags().contains(vt.growsOnTag) ) {
							bs.addSprite( new BasicSprite( sectionName+"/veg"+(++vegCount), vt.cloneSprite, spriteX, spriteY, 0d ) );
						}
					}
				}
			}
		}
	    return bs;
	}
}
