package togos.game2.worldgen.noise;

import togos.game2.function.FunctionDDD;

public class MultiMultiplyNoise implements FunctionDDD
{
	FunctionDDD basisFunction;
	double[] size;
	double[] amp;
	double[] amcSize;

	public MultiMultiplyNoise(double[] data) {
		this.basisFunction = new D5_2Perlin();
		this.setData(data);
	}

	public MultiMultiplyNoise(FunctionDDD basis, double[] data) {
		this.basisFunction = basis;
		this.setData(data);
	}

	public void setData(double[] ds) {
		int n = ds.length / 3;
		this.size = new double[n];
		this.amp = new double[n];
		this.amcSize = new double[n];
		for( int i = 0; i < n; ++i ) {
			this.size[i] = ds[3 * i + 0];
			this.amp[i] = ds[3 * i + 1];
			this.amcSize[i] = ds[3 * i + 2];
		}
	}

	public double apply(double x, double y) {
		double r = 0;
		final FunctionDDD basis = this.basisFunction;
		for( int i = 0; i < size.length; ++i ) {
			double s = size[i];
			double m = amcSize[i];
			r += basis.apply(x / s, y / s) * amp[i] * basis.apply(x / m, y / m);
		}
		return r;
	}
}
